IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_PED_VD_EST_WMS_SAI') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PED_VD_EST_WMS_SAI](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PED] [int] NOT NULL,
	[CD_PED_WMS] [int] NOT NULL,
 CONSTRAINT [PK_EST_PED_VD_EST_WMS_SAI] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PED] ASC,
	[CD_PED_WMS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] ADD  CONSTRAINT [DF_EST_PED_VD_EST_WMS_SAI_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] ADD  CONSTRAINT [DF_EST_PED_VD_EST_WMS_SAI_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] ADD  CONSTRAINT [DF_EST_PED_VD_EST_WMS_SAI_CD_PED]  DEFAULT ((0)) FOR [CD_PED]

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] ADD  CONSTRAINT [DF_EST_PED_VD_EST_WMS_SAI_CD_PED_WMS]  DEFAULT ((0)) FOR [CD_PED_WMS]

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_EST_WMS_SAI_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] CHECK CONSTRAINT [FK_EST_PED_VD_EST_WMS_SAI_EST_PED_VD]

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_EST_WMS_SAI_EST_WMS_SAI] FOREIGN KEY([CD_PED_WMS])
REFERENCES [dbo].[EST_WMS_SAI] ([CD_PED_WMS])

ALTER TABLE [dbo].[EST_PED_VD_EST_WMS_SAI] CHECK CONSTRAINT [FK_EST_PED_VD_EST_WMS_SAI_EST_WMS_SAI]
END